<div x-data="{ hasPackages: @entangle('has_packages'), hasCoins: @entangle('has_coins'), submitting: false }" x-on:set-submitting.window="submitting = $event.detail.value">
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('dashboard.subscriptions') }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke-width="1.5" stroke="currentColor" class="size-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                        </svg>
                    </span>
                </a>
            </div>

            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">

                <x-fas-repeat class="size-6 inline-block" />

                &nbsp;&nbsp;Add Subscription
            </p>
        </div>
    </div>


    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">

        <form wire:submit.prevent="saveProduct()" class="px-5" @submit="submitting=true">
            <div class="space-y-12">

                <div class="border-b border-gray-900/10  dark:border-gray-400 pb-12">

                    <div class="grid gap-x-6">
                        <div>
                            {{-- Product Image Field --}}
                            <livewire:product-image-field />

                            @error('featured_image')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full mt-8">
                            <label for="product_name"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Product
                                Name</label>
                            <div class="mt-2">
                                <div
                                    class="flex  items-center rounded-md bg-gray-100 pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 @error('product_name') border border-red-600 @enderror">
                                    <input type="text" wire:model="product_name"
                                        class="block min-w-0 grow py-1.5 pr-3 pl-1 text-base bg-gray-100 text-gray-900  placeholder:text-gray-400 focus:outline-none sm:text-sm/6 rounded-md"
                                        placeholder="Boxing Gloves" value="{{ old('product_name') }}">
                                </div>
                            </div>
                            @error('product_name')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="mt-8">
                            <label for="has_packages" class="text-sm/6 font-medium text-gray-900 dark:text-gray-400">Has
                                Packages
                            </label>
                            <span class="rounded-full text-gray-600">
                                <button type="button" id="has_packages" @click="hasPackages=!hasPackages"
                                    class="mt-2 flex w-8 flex-none cursor-pointer rounded-full"
                                    :class="hasPackages ? 'bg-green-400' : 'bg-gray-200'" role="switch"
                                    aria-checked="false" aria-labelledby="switch-1-label">
                                    <span aria-hidden="true"
                                        class="size-4 transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"
                                        :class="hasPackages ? 'translate-x-3.5' : 'translate-x-0'"></span>
                                </button>
                            </span>
                        </div>

                        <div class="mt-8">
                            <label for="has_coins" class="text-sm/6 font-medium text-gray-900 dark:text-gray-400">Has
                                Coins
                            </label>
                            <span class="rounded-full text-gray-600">
                                <button type="button" id="has_coins" @click="hasCoins=!hasCoins"
                                    class="mt-2 flex w-8 flex-none cursor-pointer rounded-full"
                                    :class="hasCoins ? 'bg-green-400' : 'bg-gray-200'" role="switch"
                                    aria-checked="false" aria-labelledby="switch-1-label">
                                    <span aria-hidden="true"
                                        class="size-4 transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"
                                        :class="hasCoins ? 'translate-x-3.5' : 'translate-x-0'"></span>
                                </button>
                            </span>
                        </div>

                        <div class="col-span-full" x-show="!hasPackages" x-cloak>

                            <div class="col-span-full mt-8">
                                <label for="price"
                                    class="block text-sm/6 font-semibold text-gray-900 dark:text-gray-400">Product
                                    Price</label>
                                <div class="mt-2">
                                    <input wire:model="price" type="text"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('price') border border-red-600 @enderror"
                                        placeholder="$100" value="{{ old('price') }}">
                                </div>

                                @error('price')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full mt-8" x-show="hasCoins" x-cloak>
                                <label for="coin"
                                    class="block text-sm/6 font-semibold text-gray-900 dark:text-gray-400">Coin
                                </label>
                                <div class="mt-2">
                                    <input wire:model="coin" type="text"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('coin') border border-red-600 @enderror"
                                        value="{{ old('coin') }}">
                                </div>

                                @error('coin')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full mt-8">
                                <label for="shop_online_link"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Subscription
                                    Link
                                </label>
                                <div class="mt-2">
                                    <input wire:model="shop_online_link"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('shop_online_link') border border-red-600 @enderror"
                                        value="{{ old('shop_online_link') }}">
                                </div>

                                @error('shop_online_link')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        <div class="col-span-full mt-8" x-data="richTextEditor1000()">
                            <label for="description"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">
                                Description
                            </label>
                            <div class="mt-2" wire:ignore>
                                <textarea wire:model="description" x-ref="editor" rows="3" @change="updateCount" :maxlength="maxChars"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6">{{ old('description') }}</textarea>
                            </div>

                            @error('description')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror

                            <p class="mt-3 text-sm/6 text-gray-600">
                                Write a few sentences about the product.
                                (<span x-text="`${charCount}/${maxChars}`"></span>)
                            </p>
                        </div>

                        {{-- Tiers/Packages --}}
                        <div class="col-span-full mt-8" x-show="hasPackages" x-cloak>
                            <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Subscription
                                Packages</label>

                            @foreach ($subscription_options as $index => $option)
                                <div class="mt-6 p-5 border rounded-2xl bg-gray-50 dark:bg-zinc-800 relative">

                                    {{-- Remove Button --}}
                                    @if ($index > 0)
                                        <button type="button" wire:click="removeProduct({{ $index }})"
                                            class="absolute top-3 right-3 text-red-600 hover:text-red-800 font-bold text-lg">✕</button>
                                    @endif

                                    {{-- Title --}}
                                    <div class="col-span-full">
                                        <label for="subscription_options.{{ $index }}.title"
                                            class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Title</label>
                                        <div class="mt-2">
                                            <input wire:model="subscription_options.{{ $index }}.title"
                                                class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('subscription_options.' . $index . '.title') border border-red-600 @enderror"
                                                placeholder="Package Title">
                                        </div>
                                        @error('subscription_options.' . $index . '.title')
                                            <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    {{-- Price --}}
                                    <div class="col-span-full mt-4">
                                        <label for="subscription_options.{{ $index }}.price"
                                            class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Price</label>
                                        <div class="mt-2">
                                            <input wire:model="subscription_options.{{ $index }}.price"
                                                class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('subscription_options.' . $index . '.price') border border-red-600 @enderror"
                                                placeholder="$100">
                                        </div>
                                        @error('subscription_options.' . $index . '.price')
                                            <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    {{-- Coin --}}
                                    <div class="col-span-full mt-4" x-show="hasCoins" x-cloak>
                                        <label for="subscription_options.{{ $index }}.coin"
                                            class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Coin</label>
                                        <div class="mt-2">
                                            <input wire:model="subscription_options.{{ $index }}.coin"
                                                class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('subscription_options.' . $index . '.coin') border border-red-600 @enderror"
                                                placeholder="Coin">
                                        </div>
                                        @error('subscription_options.' . $index . '.coin')
                                            <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    {{-- Subscription Link --}}
                                    <div class="col-span-full mt-4">
                                        <label for="subscription_options.{{ $index }}.subscription_link"
                                            class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Subscription
                                            Link</label>
                                        <div class="mt-2">
                                            <input
                                                wire:model="subscription_options.{{ $index }}.subscription_link"
                                                type="url"
                                                class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('subscription_options.' . $index . '.subscription_link') border border-red-600 @enderror"
                                                placeholder="https://example.com">
                                        </div>
                                        @error('subscription_options.' . $index . '.subscription_link')
                                            <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    {{-- Tier Description --}}
                                    <div class="col-span-full mt-4" x-data="richTextEditor()">
                                        <label for="subscription_options.{{ $index }}.tier_description"
                                            class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Package
                                            Description</label>
                                        <div class="mt-2" wire:ignore>
                                            <textarea wire:model="subscription_options.{{ $index }}.tier_description" x-ref="editor" rows="3"
                                                @change="updateCount" :maxlength="maxChars"
                                                class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6"
                                                placeholder="Describe this package"></textarea>
                                        </div>
                                        @error('subscription_options.' . $index . '.tier_description')
                                            <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                        @enderror
                                        <p class="mt-3 text-sm/6 text-gray-600">
                                            Write a few sentences about the product.
                                            (<span x-text="`${charCount}/${maxChars}`"></span>)
                                        </p>
                                    </div>

                                </div>
                            @endforeach

                            {{-- Add More Button --}}
                            <button type="button" wire:click="addProduct"
                                class="mt-5 inline-flex items-center gap-2 rounded-md bg-green-500 px-3 py-2 text-white text-sm font-semibold hover:bg-green-600">
                                ➕ Add another
                            </button>
                        </div>
                    </div>

                </div>

            </div>


            <div class="mt-6 flex items-center justify-end gap-x-6 gap-4">
                <button type="submit" :disabled="submitting"
                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">

                    <!-- Normal text -->
                    <span x-show="!submitting">Add Product
                    </span>

                    <!-- Saving text -->
                    <span x-show="submitting" class="inline-flex items-center justify-center space-x-2">
                        <span class="text-white">Saving...</span>
                        <svg class="animate-spin h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg"
                            fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor"
                                stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z">
                            </path>
                        </svg>
                    </span>
                </button>
            </div>
        </form>
    </div>

</div>
