<div>
    @if ($check_if_product_is_from_user)
        <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">

            <div class="grid grid-cols-5 gap-4">
                <div class="flex items-center col-span-1">
                    <a wire:navigate
                        href="{{ $is_subscription ? route('subscriptions.edit', $product_id) : route('product.edit', $product_id) }}"
                        class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                        <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-4">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                            </svg>
                        </span>
                    </a>
                </div>

                <p
                    class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">

                    <x-heroicon-o-photo class="size-6 inline-block" />

                    &nbsp;&nbsp;Add Images
                </p>

            </div>

        </div>

        <div x-cloak
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20 px-5">

            <div wire:ignore>
                <div x-data="{ loaded: false }" x-init="setTimeout(() => loaded = true, 1500)">
                    <div @click="$el.nextElementSibling.querySelector('input[type=file]').click()" x-show="loaded"
                        class="flex justify-center text-slate-800 dark:text-slate-300 pt-10 cursor-pointer">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                            stroke="currentColor" class="size-16 text-lg font-bold cursor-pointer">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5m-13.5-9L12 3m0 0 4.5 4.5M12 3v13.5" />
                        </svg>
                    </div>

                    {{-- <p class="text-slate-800 dark:text-slate-300">{{ $to_upload_count }}</p> --}}

                    <div x-cloak x-show="loaded">
                        {{-- <div> --}}
                        <input type="file" multiple id="fileInput" data-max-file-size="5MB"
                            data-max-files="{{ $to_upload_count }}"
                            accept="image/png, image/jpeg, image/gif, image/heic, image/heif, image/avif, image/webp" />
                    </div>
                </div>

                <div class="mt-6 flex items-center justify-end gap-x-6 gap-4">
                    <button type="button" wire:click.prevent="saveImages" id="saveButton"
                        class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 hidden">
                        Add to Gallery
                    </button>

                    <div class="flex flex-wrap">
                        @foreach ($images as $index => $tempImage)
                            <div class="w-1/4 p-2">
                                <img src="{{ $tempImage->temporaryUrl() }}" alt="Image"
                                    class="w-full h-full object-cover" />
                                <button wire:click.prevent="removeTempImage({{ $tempImage->getFilename() }})"
                                    class="text-red-500">Remove</button>
                            </div>
                        @endforeach
                    </div>
                </div>

                @push('scripts')
                    <script src="https://cdn.jsdelivr.net/npm/heic2any@0.0.3/dist/heic2any.min.js"></script>
                    <script src="https://unpkg.com/filepond/dist/filepond.min.js"></script>
                    <script src="https://unpkg.com/filepond-plugin-image-exif-orientation/dist/filepond-plugin-image-exif-orientation.js">
                    </script>
                    <script src="https://unpkg.com/filepond-plugin-image-crop/dist/filepond-plugin-image-crop.js"></script>
                    <script src="https://unpkg.com/filepond-plugin-image-preview/dist/filepond-plugin-image-preview.min.js"></script>
                    <script src="https://unpkg.com/filepond-plugin-file-validate-type/dist/filepond-plugin-file-validate-type.js"></script>
                    <script src="https://unpkg.com/filepond-plugin-image-transform/dist/filepond-plugin-image-transform.js"></script>
                    <script src="https://unpkg.com/filepond-plugin-image-resize/dist/filepond-plugin-image-resize.js"></script>

                    <script>
                        window.pondInstance = null;
                        window.maxFiles = document.getElementById('fileInput')
                            .getAttribute('data-max-files');

                        window.addEventListener('livewire:navigated', function() {

                            Livewire.on('no-images-left', () => {
                                document.getElementById('saveButton')?.classList.add('hidden');
                            });

                            Livewire.on('images-exist', () => {
                                document.getElementById('saveButton')?.classList.remove('hidden');
                            });

                            if (document.querySelector('#fileInput')) {

                                setTimeout(function() {
                                    // Register FilePond plugins
                                    FilePond.registerPlugin(
                                        FilePondPluginImagePreview,
                                        FilePondPluginImageCrop,
                                        FilePondPluginImageTransform,
                                        FilePondPluginImageExifOrientation,
                                        FilePondPluginFileValidateType,
                                        FilePondPluginImageResize
                                    );

                                    window.pondInstance = FilePond.create(document.getElementById('fileInput'), {
                                        labelIdle: 'Tap to upload {{ $to_upload_count }} image(s)',
                                        allowImagePreview: true,
                                        allowImageCrop: true,
                                        imageCropAspectRatio: '1:1',
                                        imageResizeTargetWidth: 600,
                                        imageResizeTargetHeight: 600,
                                        imagePreviewMaxFileSize: '3MB',
                                        imagePreviewHeight: 170,
                                        credits: false,
                                        maxFiles: window.maxFiles,
                                        allowMultiple: true,
                                        onwarning: (error, file, status) => {
                                            if (error.code === 0) {
                                                alert('You can only upload ' + window.maxFiles + ' image(s).');
                                            }
                                        },
                                        allowFileTypeValidation: true,
                                        acceptedFileTypes: [
                                            'image/png',
                                            'image/jpg',
                                            'image/jpeg',
                                            'image/gif',
                                            'image/heic',
                                            'image/heif',
                                            'image/avif',
                                            'image/webp'
                                        ],

                                        allowImageExifOrientation: true,

                                        beforeAddFile: async (fileItem) => {
                                            const file = fileItem.file;
                                            const isHEIC = file.type === 'image/heic' || file
                                                .type ===
                                                'image/heif';

                                            if (!isHEIC) return true;

                                            try {
                                                const arrayBuffer = await file.arrayBuffer();
                                                const convertedBlob = await heic2any({
                                                    blob: new Blob([arrayBuffer]),
                                                    toType: 'image/jpeg',
                                                    quality: 0.9
                                                });

                                                const jpegFile = new File(
                                                    [convertedBlob],
                                                    file.name.replace(/\.[^/.]+$/, '') +
                                                    '.jpg', {
                                                        type: 'image/jpeg'
                                                    }
                                                );

                                                window.pondInstance.addFile(jpegFile);
                                                return false;
                                            } catch (err) {
                                                alert('Failed to convert HEIC image: ' + err
                                                    .message);
                                                return false;
                                            }
                                        },

                                        server: {
                                            process: (fieldName, file, metadata, load, error,
                                                progress, abort) => {
                                                window.hasUnsavedImages = true;
                                                @this.upload(
                                                    'images',
                                                    file,
                                                    (fileNameOnServer) => {
                                                        // Pass the Livewire temp filename back to FilePond
                                                        load(fileNameOnServer);
                                                    },
                                                    (err) => error(err),
                                                    (prog) => progress(true, prog, 100)
                                                );
                                            },
                                            revert: (uniqueFileId, load, error) => {
                                                @this.removeTempImage(uniqueFileId).then(() => {
                                                    @this.call('checkImages');
                                                });
                                                load();
                                            }
                                        },

                                        onaddfile: () => {
                                            const currentFiles = window.pondInstance.getFiles().length;
                                            console.log(currentFiles);
                                            if (currentFiles >= maxFiles) {
                                                document.querySelector(
                                                        '.flex.justify-center.pt-10.cursor-pointer').style
                                                    .display = 'none';
                                            } else {
                                                document.querySelector(
                                                        '.flex.justify-center.pt-10.cursor-pointer').style
                                                    .display = 'flex';
                                            }

                                            window.hasUnsavedImages = true;
                                        },
                                        onremovefile: () => {
                                            // window.hasUnsavedImages = true;
                                            const currentFiles = window.pondInstance.getFiles().length;

                                            if (currentFiles < maxFiles) {
                                                document.querySelector(
                                                        '.flex.justify-center.pt-10.cursor-pointer').style
                                                    .display = 'flex';
                                            }
                                        },
                                        onprocessfiles: () => {
                                            console.log('Finished uploading all files!');
                                            window.hasUnsavedImages = false;
                                            document.getElementById('saveButton').classList.remove(
                                                'hidden');
                                        }
                                    });
                                }, 1000);
                            }
                        });

                        // Save button resets the unsaved flag
                        window.addEventListener('images-saved', () => {
                            window.hasUnsavedImages = false;
                        });

                        window.addEventListener('beforeunload', function(event) {
                            if (window.hasUnsavedImages) {
                                event.preventDefault();
                                event.returnValue = "You have unsaved images. If you leave this page, they will be lost.";
                            }
                        });

                        // Define only once globally
                        window.hasUnsavedImages = window.hasUnsavedImages || false;

                        document.addEventListener('livewire:navigating', (event) => {
                            const currentPath = window.location.pathname;

                            // Only ask for confirmation if user is LEAVING the upload page
                            if (currentPath === '/image/add' && window.hasUnsavedImages) {
                                const confirmed = confirm(
                                    "You have unsaved images. If you leave this page, they will be lost. Are you sure?"
                                );

                                if (!confirmed) {
                                    event.preventDefault(); // Cancel SPA navigation
                                } else {
                                    window.hasUnsavedImages = false; // Clear flag so it won't show again
                                }
                            }
                        });
                    </script>
                @endpush
            </div>

        </div>
    @else
        <div id="custom_bg" class="h-screen flex justify-center items-center">
            <div>
                {{-- <p class="mx-auto text-yellow-500 text-center text-l p-10">
                <x-ionicon-warning-sharp class="size-32 sm:size-40" />
            </p> --}}
                <p class="mx-auto font-medium text-center text-xl">Invalid action. </p>

                <a href="{{ route('dashboard.product') }}"
                    class="inline-flex mt-5 px-4 py-3 rounded-full text-center text-l font-bold"
                    style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                    Back to Products Page
                </a>

            </div>
        </div>
    @endif
</div>
