<div x-data="{ submitting: false }" x-on:set-submitting.window="submitting = $event.detail.value">
    <!-- Header / Back -->
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">
        <div class="grid grid-cols-5 gap-4">
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('dashboard.pages') }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900">
                        <!-- back icon -->
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                            stroke="currentColor" class="size-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                        </svg>
                    </span>
                </a>
            </div>

            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-400 text-center text-l py-1 my-5 font-bold col-span-3">
                <x-heroicon-o-document class="size-6 inline-block" />
                &nbsp;&nbsp;Add Page
            </p>
        </div>
    </div>

    <!-- Form -->
    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">
        <form wire:submit.prevent="savePage" class="px-5" @submit="submitting=true">
            <div class="space-y-6">
                <div class="grid gap-4">

                    <!-- Title -->
                    <div>
                        <label class="block text-sm font-medium text-gray-900 dark:text-gray-400">Page Title</label>
                        <input type="text" wire:model.lazy="title"
                            class="mt-2 block w-full rounded-md bg-gray-100 px-3 py-2" placeholder="Page title" />
                        @error('title')
                            <p class="text-red-600 mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Description -->
                    <div>
                        <label class="block text-sm font-medium text-gray-900 dark:text-gray-400">Description</label>
                        <textarea wire:model.lazy="description" rows="3" class="mt-2 block w-full rounded-md bg-gray-100 px-3 py-2"
                            placeholder="Optional description"></textarea>
                        @error('description')
                            <p class="text-red-600 mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Active Toggle -->
                    <div x-data="{ isActive: @entangle('is_active') }">
                        <label for="is_active" class="text-sm/6 font-medium text-gray-900 dark:text-gray-400">
                            Title Visible on Page
                        </label>
                        <span class="rounded-full text-gray-600">
                            <button type="button" id="is_active" @click="isActive = !isActive"
                                class="mt-2 flex w-8 flex-none cursor-pointer rounded-full"
                                :class="isActive ? 'bg-green-400' : 'bg-gray-200'" role="switch" aria-checked="false"
                                aria-labelledby="switch-1-label">
                                <span aria-hidden="true"
                                    class="size-4 transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"
                                    :class="isActive ? 'translate-x-3.5' : 'translate-x-0'"></span>
                            </button>
                        </span>
                    </div>

                    <!-- Blocks List -->
                    <div>
                        <label class="block text-sm font-medium text-gray-900 dark:text-gray-400">Contents</label>
                        <div class="mt-2 space-y-4" x-data x-sortable x-on:sorted="$wire.updateOrder($event.detail)">
                            @forelse($contents as $index => $block)
                                <div x-data="{ open: true }" class="border rounded p-3 bg-gray-50 dark:bg-zinc-800"
                                    wire:key="block-{{ $index }}" x-sortable-item="{{ $index }}">
                                    <div class="flex items-center justify-between">
                                        <div class="flex items-center gap-2 font-semibold">
                                            <!-- Drag handle -->
                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                class="w-4 h-4 cursor-move text-gray-400" fill="none"
                                                viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M4 7h16M4 12h16M4 17h16" />
                                            </svg>

                                            <!-- Collapse toggle -->
                                            <button type="button" @click="open = !open"
                                                class="text-gray-500 hover:text-gray-700">
                                                <template x-if="open">
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor"
                                                        viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            stroke-width="2" d="M19 9l-7 7-7-7" />
                                                    </svg>
                                                </template>
                                                <template x-if="!open">
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor"
                                                        viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            stroke-width="2" d="M9 5l7 7-7 7" />
                                                    </svg>
                                                </template>
                                            </button>

                                            <span class="text-gray-900 dark:text-gray-400">
                                                {{ ucfirst($block['type']) }} Block
                                            </span>
                                        </div>

                                        <div class="flex items-center gap-2">
                                            <button type="button" wire:click.prevent="moveUp({{ $index }})"
                                                class="px-2 py-1 bg-white rounded">↑</button>
                                            <button type="button" wire:click.prevent="moveDown({{ $index }})"
                                                class="px-2 py-1 bg-white rounded">↓</button>
                                            {{-- <button type="button"
                                                wire:click.prevent="removeBlock({{ $index }})"
                                                class="px-2 py-1 bg-red-500 text-white rounded">Remove</button> --}}

                                            <button type="button" wire:click.prevent="removeBlock({{ $index }})"
                                                class="p-2 bg-red-500 text-white rounded hover:bg-red-600 transition">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none"
                                                    viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        d="M6 7h12M9 7V4h6v3m-7 4v7m4-7v7m4-7v7M4 7h16l-1 12a2 2 0 01-2 2H7a2 2 0 01-2-2L4 7z" />
                                                </svg>
                                            </button>
                                        </div>
                                    </div>

                                    <!-- Block Content -->
                                    <div x-show="open" x-transition class="mt-3">
                                        @if ($block['type'] === 'heading')
                                            <input type="text" wire:model.lazy="contents.{{ $index }}.value"
                                                class="mt-1 block w-full rounded-md bg-white px-3 py-2" required />

                                            @error("contents.$index.value")
                                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                            @enderror
                                        @elseif($block['type'] === 'html')
                                            <textarea x-data="richTextEditor()" wire:model.lazy="contents.{{ $index }}.value" x-ref="editor"
                                                rows="4"
                                                class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-400 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6"
                                                required></textarea>

                                            @error("contents.$index.value")
                                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                            @enderror
                                        @elseif($block['type'] === 'video')
                                            <input type="text"
                                                wire:model.lazy="contents.{{ $index }}.value"
                                                class="mt-1 block w-full rounded-md bg-white px-3 py-2"
                                                placeholder="youtube, vimeo, instagram or tiktok video" required />

                                            @error("contents.$index.value")
                                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                            @enderror
                                        @elseif($block['type'] === 'button')
                                            <label
                                                class="block text-sm font-medium mt-2 text-gray-900 dark:text-gray-400">
                                                Title</label>
                                            <input type="text"
                                                wire:model.lazy="contents.{{ $index }}.title"
                                                class="mt-1 block w-full rounded-md bg-white px-3 py-2"
                                                placeholder="Button Title" required />

                                            @error("contents.$index.title")
                                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                            @enderror

                                            <label
                                                class="block text-sm font-medium mt-2 text-gray-900 dark:text-gray-400">
                                                URL</label>
                                            <input type="text"
                                                wire:model.lazy="contents.{{ $index }}.value"
                                                class="mt-1 block w-full rounded-md bg-white px-3 py-2"
                                                placeholder="https://example.com" required />
                                            @error("contents.$index.value")
                                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                            @enderror
                                        @elseif($block['type'] === 'image')
                                            <div class="mt-2">
                                                @if (isset($block['file']) && $block['file'])
                                                    <img src="{{ $block['file'] instanceof \Livewire\Features\SupportFileUploads\TemporaryUploadedFile ? $block['file']->temporaryUrl() : (isset($block['value']) ? asset('storage/' . $block['value']) : '') }}"
                                                        class="w-full object-cover rounded-md" alt="preview">
                                                @elseif(isset($block['value']) && $block['value'])
                                                    <img src="{{ asset('storage/' . $block['value']) }}"
                                                        class="w-full object-cover rounded" alt="preview">
                                                @endif
                                            </div>
                                            <input type="file" wire:model="contents.{{ $index }}.file"
                                                class="mt-2 text-gray-900 dark:text-gray-400" accept="image/*" />

                                            @error("contents.$index.file")
                                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                            @enderror

                                            <label
                                                class="block text-sm font-medium mt-2 text-slate-800 dark:text-slate-400">URL</label>
                                            <input type="url"
                                                wire:model.lazy="contents.{{ $index }}.call_to_action"
                                                class="mt-1 block w-full rounded-md bg-white px-3 py-2"
                                                placeholder="https://example.com" />

                                            <div wire:loading wire:target="contents.{{ $index }}.file"
                                                class="text-gray-900 dark:text-gray-400">
                                                Uploading...
                                            </div>
                                            @if ($errors->has('contents.' . $index . '.file'))
                                                <p class="text-red-600 mt-1">
                                                    {{ $errors->first('contents.' . $index . '.file') }}</p>
                                            @endif
                                        @endif
                                    </div>
                                </div>
                            @empty
                                <p class="text-sm text-gray-500">No blocks yet — use "Add Block" to start building your
                                    page.</p>
                            @endforelse
                        </div>
                    </div>

                    <!-- Add Block Buttons -->
                    <div>
                        <label class="block text-sm font-medium text-gray-900 dark:text-gray-400">Add Block</label>
                        <div class="mt-2 flex gap-2 flex-wrap">
                            <button type="button" wire:click.prevent="addBlock('heading')"
                                class="px-3 py-1 bg-gray-200 rounded">Heading</button>
                            <button type="button" wire:click.prevent="addBlock('html')"
                                class="px-3 py-1 bg-gray-200 rounded">HTML</button>
                            <button type="button" wire:click.prevent="addBlock('image')"
                                class="px-3 py-1 bg-gray-200 rounded">Image</button>
                            <button type="button" wire:click.prevent="addBlock('video')"
                                class="px-3 py-1 bg-gray-200 rounded">Video</button>
                            <button type="button" wire:click.prevent="addBlock('button')"
                                class="px-3 py-1 bg-gray-200 rounded">Button</button>
                        </div>
                    </div>
                </div>

                <!-- Save Button -->
                <div class="flex justify-end gap-3 mt-4">
                    <button type="submit" :disabled="submitting" class="rounded-md px-4 py-2 bg-yellow-400">

                        <!-- Normal text -->
                        <span x-show="!submitting">Save Page</span>

                        <!-- Saving text -->
                        <span x-show="submitting" class="inline-flex items-center justify-center space-x-2">
                            <span class="text-white">Saving...</span>
                            <svg class="animate-spin h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg"
                                fill="none" viewBox="0 0 24 24">
                                <circle class="opacity-25" cx="12" cy="12" r="10"
                                    stroke="currentColor" stroke-width="4"></circle>
                                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z">
                                </path>
                            </svg>
                        </span>
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>
