@php
    $products = $getRecord()->products ?? [];
@endphp

<div class="overflow-x-auto rounded-xl border border-gray-200 bg-white shadow-sm dark:border-gray-700 dark:bg-gray-800">
    <table class="w-full text-sm divide-y divide-gray-200 dark:divide-gray-700">
        <thead class="bg-gray-50 dark:bg-gray-700">
            <tr class="text-gray-700 dark:text-gray-200 uppercase text-xs font-medium tracking-wider">
                <th class="px-4 py-3 text-left">Image</th>
                <th class="px-4 py-3 text-left">Product</th>
                <th class="px-4 py-3 text-left">Options</th>
                <th class="px-4 py-3 text-left">Price</th>
                <th class="px-4 py-3 text-left">Qty</th>
                <th class="px-4 py-3 text-left">Total</th>
            </tr>
        </thead>
        <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
            @foreach ($products as $item)
                @php
                    $product = \App\Models\Product::find($item['product_id']);
                    $quantity = $item['quantity'] ?? 1;
                    $price = $item['price'] ?? 0;
                    $options = $item['options'] ?? [];
                @endphp
                <tr class="dark:hover:bg-gray-700">
                    <td class="px-4 py-2">
                        <img src="{{ $product?->featured_image ? asset('storage/' . $product->featured_image) : asset('/img/product-placeholder.jpg') }}"
                            class="w-16 h-16 object-cover rounded-lg" />
                    </td>
                    <td class="px-4 py-2 font-medium text-gray-800 dark:text-gray-200">
                        {{ $product?->product_name ?? 'Unknown' }}
                    </td>
                    <td class="px-4 py-2 text-gray-600 dark:text-gray-400">
                        @if ($options)
                            @foreach ($options as $key => $value)
                                @if ($value)
                                    <span class="mr-2">{{ ucfirst($key) }}: {{ $value }}</span>
                                @endif
                            @endforeach
                        @else
                            N/A
                        @endif
                    </td>
                    <td class="px-4 py-2 text-gray-600 dark:text-gray-400">${{ number_format($price, 2) }}</td>
                    <td class="px-4 py-2 text-gray-600 dark:text-gray-400">{{ $quantity }}</td>
                    <td class="px-4 py-2 font-semibold text-gray-800 dark:text-gray-200">
                        ${{ number_format($price * $quantity, 2) }}</td>
                </tr>
            @endforeach
        </tbody>
        <tfoot class="bg-gray-50 dark:bg-gray-700 font-semibold text-gray-800 dark:text-gray-200">
            <tr>
                <td colspan="5" class="px-4 py-3 text-right">Grand Total:</td>
                <td class="px-4 py-3">
                    ${{ number_format(collect($products)->sum(fn($item) => ($item['price'] ?? 0) * ($item['quantity'] ?? 1)), 2) }}
                </td>
            </tr>
        </tfoot>
    </table>
</div>
