<!-- Action Sheet -->
<div class="z-20 fixed sm:w-7/12 md:w-6/12 lg:w-4/12 mx-auto bottom-0 left-0 right-0 bg-white dark:bg-zinc-900 shadow-lg transform translate-y-full transition-transform duration-300 rounded-t-2xl"
    :class="{ 'translate-y-full': !actionSheet, 'translate-y-0': actionSheet }">
    <div class="p-4">
        <div class="flex justify-between">
            <h3 class="text-lg font-bold text-slate-800 dark:text-slate-300 flex items-center">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-6">
                    <path fill-rule="evenodd"
                        d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                        clip-rule="evenodd" />
                </svg>&nbsp;&nbsp;
                Add New
            </h3>
            <!-- Close Action Sheet -->
            <button @click="actionSheet=!actionSheet" class="text-gray-500 toggleActionSheet">
                <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6" viewBox="0 0 24 24" fill="none"
                    stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>
        <div class="mt-4 space-y-3">
            <a wire:navigate href="{{ route('dashboard.button') }}"
                class="block px-4 py-2 text-left text-slate-800 dark:text-slate-300 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 hover:text-blue-600">Link</a>
            <a wire:navigate href="{{ route('dashboard.social') }}"
                class="block px-4 py-2 text-left text-slate-800 dark:text-slate-300 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 hover:text-blue-600">Social
                Media</a>

            @can('view', App\Models\Image::class)
                <a wire:navigate href="{{ route('dashboard.images') }}"
                    class="block px-4 py-2 text-left text-slate-800 dark:text-slate-300 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 hover:text-blue-600">Gallery</a>
            @endcan

            @can('view', App\Models\Video::class)
                <a wire:navigate href="{{ route('dashboard.video') }}"
                    class="block px-4 py-2 text-left text-slate-800 dark:text-slate-300 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 hover:text-blue-600">Video</a>
            @endcan

            @if (in_array($user_type, ['Free', 'Basic', 'Gold', 'Platinum', 'Sponsored', 'Influencer']))
                {{-- Contact Points --}}
                <a wire:navigate href="{{ route('contacts.index') }}"
                    class="block px-4 py-2 text-left text-slate-800 dark:text-slate-300 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 hover:text-blue-600">Contact
                    Point</a>
            @endif

            @if ($user_type != 'Free')
                {{-- Payment Links --}}
                <a wire:navigate href="{{ route('payments.index') }}"
                    class="block px-4 py-2 text-left text-slate-800 dark:text-slate-300 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 hover:text-blue-600">Accept
                    Payment</a>
            @endif

            {{-- @if (in_array($user_type, ['Gold', 'Platinum'])) --}}
            <a wire:navigate href="{{ route('directions.index') }}"
                class="block px-4 py-2 text-left text-slate-800 dark:text-slate-300 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 hover:text-blue-600">Driving
                Direction</a>
            {{-- @endif --}}

            @if (in_array($user_type, ['Basic', 'Gold', 'Platinum', 'Influencer']))
                <a wire:navigate href="{{ route('communities.index') }}"
                    class="block px-4 py-2 text-left text-slate-800 dark:text-slate-300 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 hover:text-blue-600">Community</a>
            @endif

            @if (in_array($user_type, ['Basic', 'Gold', 'Platinum']))
                {{-- Products --}}
                <a wire:navigate href="{{ route('dashboard.event') }}"
                    class="block px-4 py-2 text-left text-slate-800 dark:text-slate-300 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 hover:text-blue-600">Event
                    Page</a>
            @endif

            @if (in_array($user_type, ['Gold', 'Platinum']))
                {{-- Products --}}
                <a wire:navigate href="{{ route('dashboard.product') }}"
                    class="block px-4 py-2 text-left text-slate-800 dark:text-slate-300 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 hover:text-blue-600">Product</a>
            @endif

            {{-- @if (in_array($user_type, ['Gold', 'Platinum']))
                <a wire:navigate href="{{ route('dashboard.sales') }}"
                    class="block px-4 py-2 text-left text-slate-800 dark:text-slate-300 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 hover:text-blue-600">Sales
                    Page</a>
            @endif --}}

            @if (in_array($user_type, ['Gold', 'Platinum', 'Sponsored', 'Influencer']))
                @php
                    $maxCard = 0;
                    $availableSlot = 0;
                    $verbiage = ' Slots';

                    if (auth()->user()->user_type === 'Gold') {
                        $maxCard = 3;
                    }

                    if (auth()->user()->user_type === 'Platinum') {
                        $maxCard = 12;
                    }

                    // if (auth()->user()->user_type === 'Sponsored') {
                    if (in_array(auth()->user()->user_type, ['Sponsored', 'Influencer'])) {
                        $maxCard = 1;
                    }

                    $availableSlot = $maxCard - $subcards_count;

                @endphp

                @if ($availableSlot >= 1)
                    {{-- Sub Card --}}
                    <a wire:navigate href="{{ route('card.add') }}"
                        class="block px-4 py-2 text-left text-slate-800 dark:text-slate-300 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 hover:text-blue-600">New
                        Card</a>
                @endif
            @endif

            <button @click="actionSheet=!actionSheet"
                class="w-full px-4 py-2 text-left text-red-600 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950">Cancel</button>
        </div>
    </div>
</div>
