// --- Cart Helpers ---
function getCartItems() {
    let items = [];
    for (let key in localStorage) {
        if (key.startsWith("cart_")) {
            try {
                const item = JSON.parse(localStorage.getItem(key));
                if (item.quantity > 0) items.push(item);
            } catch (e) { }
        }
    }
    return items;
}

function saveToCart(productId, productType) {
    const input = document.getElementById("quantity-" + productId) ||
        document.getElementById(`cart-input-${productType}-${productId}`);
    if (!input) return;

    const quantity = parseInt(input.value) || 0;
    const price = parseFloat(input.getAttribute("data-price")) || 0;
    const name = input.getAttribute("data-name") || "Unnamed Product";
    const image = input.getAttribute("data-image") || null;

    const item = { id: productId, type: productType, quantity, price, name, image };
    localStorage.setItem("cart_" + productType + "_" + productId, JSON.stringify(item));
}

function updateCartFooter() {
    const items = getCartItems();
    const total = items.reduce((sum, item) => sum + (item.quantity * item.price), 0);

    const footer = document.getElementById("cart-footer");
    const totalEl = document.getElementById("cart-total");

    if (footer && totalEl) {
        if (items.length > 0) {
            footer.classList.remove("hidden");
            totalEl.textContent = total.toFixed(2);
        } else {
            footer.classList.add("hidden");
        }
    }
}
