// import "./libs/trix";

import './bootstrap';
// import './alpinejs';
import sortable from './sortable';

import { Livewire, Alpine } from '../../vendor/livewire/livewire/dist/livewire.esm';

import tinymce from 'tinymce/tinymce';
// Themes
import 'tinymce/themes/silver';

// Icons
import 'tinymce/icons/default';

// Models
import 'tinymce/models/dom';

document.addEventListener('alpine:init', () => {
    Alpine.data('richTextEditor', () => ({
        editor: null,
        maxChars: 5000,
        charCount: 0,
        init() {
            tinymce.init({
                skin_url: '/css/tinymce/skins/ui/oxide',
                content_css: false,
                license_key: 'gpl',
                target: this.$refs.editor,
                promotion: false,
                menubar: false,
                statusbar: false,
                plugins: 'link',
                // toolbar: 'undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | outdent indent',
                toolbar: 'bold italic link alignleft aligncenter alignright alignjustify',
                setup: (editor) => {
                    this.editor = editor;
                    // editor.on('init', () => {
                    //     editor.setContent(this.$refs.editor.value || ''); // Set content on init
                    //     this.updateCount(); // Call updateCount here
                    // });

                    editor.on('init', () => {
                        editor.setContent(this.$refs.editor.value || '');
                        this.updateCount();
                    });

                    editor.on('input change undo redo', () => {
                        this.$refs.editor.value = editor.getContent();
                        this.$refs.editor.dispatchEvent(new Event('input', { bubbles: true }));
                        this.updateCount(); // Call updateCount here
                    });
                }
            });
        },

        updateCount() {
            const content = this.editor.getContent({ format: 'text' });
            const charCount = content.length;
            this.charCount = charCount;
            if (charCount > this.maxChars) {
                this.editor.setContent(content.substring(0, this.maxChars));
            }
        }
    }));
});

document.addEventListener('alpine:init', () => {
    Alpine.data('richTextEditor1000', () => ({
        editor: null,
        maxChars: 1000,
        charCount: 0,
        init() {
            tinymce.init({
                skin_url: '/css/tinymce/skins/ui/oxide',
                content_css: false,
                license_key: 'gpl',
                target: this.$refs.editor,
                promotion: false,
                menubar: false,
                statusbar: false,
                plugins: 'link',
                // toolbar: 'undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | outdent indent',
                toolbar: 'bold italic link alignleft aligncenter alignright alignjustify | bullist numlist bulletedlist orderedlist',
                setup: (editor) => {
                    this.editor = editor;
                    // editor.on('init', () => {
                    //     editor.setContent(this.$refs.editor.value || ''); // Set content on init
                    //     this.updateCount(); // Call updateCount here
                    // });

                    editor.on('init', () => {
                        editor.setContent(this.$refs.editor.value || '');
                        this.updateCount();
                    });

                    editor.on('input change undo redo', () => {
                        this.$refs.editor.value = editor.getContent();
                        this.$refs.editor.dispatchEvent(new Event('input', { bubbles: true }));
                        this.updateCount(); // Call updateCount here
                    });
                }
            });
        },

        updateCount() {
            const content = this.editor.getContent({ format: 'text' });
            const charCount = content.length;
            this.charCount = charCount;
            if (charCount > this.maxChars) {
                this.editor.setContent(content.substring(0, this.maxChars));
            }
        }
    }));
});

Alpine.plugin(sortable)
Livewire.start()
