if (!customElements.get('fanbase-icon')) {
    class fanBaseIcon extends HTMLElement {
        constructor() {
            super();
            this.attachShadow({ mode: 'open' });
            this.shadowRoot.innerHTML = `
        <style>
        :host {
          display: inline-block;
          width: 1.5em; /* size-6 equivalent */
          height: 1.5em;
        }
        svg {
          width: 100%;
          height: 100%;
          fill: currentColor;
        }
      </style>
      <svg viewBox="62.65 62.65 368.12 393.29" xmlns="http://www.w3.org/2000/svg">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M199.708 62.6509L106.259 308.949H140.128L81.3301 455.939L236.547 259.295H211.574L240.036 209.895H283.971L318.915 168.086H265.174L290.912 129.081H368.919L430.773 62.6509H199.708Z"/>
      </svg>
      `;
        }
    }

    customElements.define('fanbase-icon', fanBaseIcon);

}

if (!customElements.get('chime-icon')) {
    class ChimeIcon extends HTMLElement {
        constructor() {
            super();
            this.attachShadow({ mode: 'open' });
            this.shadowRoot.innerHTML = `
        <style>
          :host {
            display: inline-block;
            width: 1.5em;
            height: 1.5em;
          }
          svg {
            width: 100%;
            height: 100%;
            fill: currentColor; /* inherits color */
          }
        </style>
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="-203 444 193 193">
          <defs>
            <mask id="chime-mask">
              <!-- white = visible, black = transparent -->
              <rect x="-203" y="444" width="193" height="193" fill="white" />
              <!-- The “C” shape (black = transparent hole) -->
              <path fill="black" d="M-100.1,597.5c19.5,0,33.4-7.4,41.6-13.6v-26.9
                c-12.1,9.6-26.4,15.1-39,15.1c-20.2,0-34.4-13.9-34.4-33.9
                c0-19,12.9-32.2,31.3-32.2c6,0,11.2,1.5,16.7,3.1
                c5.7,1.6,11.6,3.4,18.7,3.4c2.2,0,4.4-0.2,6.6-0.5v-25.6
                c-1.9,0.2-3.6,0.3-5.5,0.3c-6.4,0-12.1-1.2-18.2-2.5
                c-6.4-1.4-12.9-2.7-20.6-2.7c-15.4,0-29.6,5.4-40.1,15.4
                c-11.1,10.6-17.1,25.4-17.1,42.6C-160,573.7-135.4,597.5-100.1,597.5z"/>
            </mask>
          </defs>

          <!-- outer square that uses the mask -->
          <path mask="url(#chime-mask)"
            d="M-59.2,637h-94.7c-27.2,0-49.2-22-49.2-49.2v-94.7
               c0-27.2,22-49.2,49.2-49.2h94.7C-32,444-10,466-10,493.2
               v94.7C-10,615-32,637-59.2,637z"/>
        </svg>
      `;
        }
    }

    customElements.define('chime-icon', ChimeIcon);
}

if (!customElements.get('skool-icon')) {
    class SkoolIcon extends HTMLElement {
        constructor() {
            super();
            this.attachShadow({ mode: 'open' });
        }

        connectedCallback() {
            this.render();
        }

        render() {
            this.shadowRoot.innerHTML = `
                <style>
                    :host {
                        display: inline-block;
                        width: 1.5em;
                        height: 1.5em;
                    }
                    svg {
                        width: 100%;
                        height: 100%;
                        display: block;
                    }
                </style>

                <svg viewBox="0 0 2783 905" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M429 403.6C424.6 410.4 420 415.4 415.2 418.6C410.8 421.4 404.6 422.8 396.6 422.8C388.6 422.8 380.4 420.8 372 416.8C363.6 412.8 354.2 408.6 343.8 404.2C333.4 399.4 321.4 395 307.8 391C294.6 387 279.2 385 261.6 385C234.8 385 214 390.6 199.2 401.8C184.4 412.6 177 427 177 445C177 457.4 181.2 467.8 189.6 476.2C198 484.6 209 492 222.6 498.4C236.6 504.4 252.4 510.2 270 515.8C287.6 521 305.6 526.8 324 533.2C342.8 539.6 361 547 378.6 555.4C396.2 563.8 411.8 574.4 425.4 587.2C439.4 599.6 450.6 614.8 459 632.8C467.4 650.4 471.6 671.8 471.6 697C471.6 727 466 754.8 454.8 780.4C444 805.6 428 827.4 406.8 845.8C385.6 864.2 359.2 878.6 327.6 889C296 899.4 259.6 904.6 218.4 904.6C197.2 904.6 176.2 902.6 155.4 898.6C134.6 895 114.8 889.8 96 883C77.2 875.8 59.6 867.6 43.2 858.4C26.8 849.2 12.6 839.2 0.6 828.4L39 766.6C43.4 759.4 48.8 753.8 55.2 749.8C62 745.8 70.6 743.8 81 743.8C91 743.8 100.2 746.4 108.6 751.6C117 756.4 126.4 761.8 136.8 767.8C147.2 773.4 159.4 778.8 173.4 784C187.8 788.8 205.6 791.2 226.8 791.2C242.8 791.2 256.6 789.4 268.2 785.8C279.8 782.2 289.2 777.4 296.4 771.4C303.6 765 308.8 758 312 750.4C315.6 742.4 317.4 734.2 317.4 725.8C317.4 712.2 313 701.2 304.2 692.8C295.8 684 284.6 676.4 270.6 670C257 663.6 241.2 657.8 223.2 652.6C205.2 647.4 186.8 641.6 168 635.2C149.6 628.8 131.4 621.2 113.4 612.4C95.8 603.6 80 592.6 66 579.4C52.4 565.8 41.2 549.2 32.4 529.6C24 510 19.8 486.2 19.8 458.2C19.8 432.6 24.8 408.4 34.8 385.6C44.8 362.4 59.8 342 79.8 324.4C99.8 306.8 124.6 292.8 154.2 282.4C184.2 272 218.8 266.8 258 266.8C302 266.8 342 274 378 288.4C414 302.8 443.6 321.6 466.8 344.8L429 403.6Z" fill="#263397"></path>
                    <path d="M740.859 0.399966V508H768.459C778.859 508 787.059 506.6 793.059 503.8C799.059 500.6 805.059 495 811.059 487L947.859 304.6C954.659 295.4 962.259 288.4 970.659 283.6C979.459 278.8 990.459 276.4 1003.66 276.4H1154.86L977.259 502C963.259 520.8 947.059 535.6 928.659 546.4C937.859 552.8 945.859 560.2 952.659 568.6C959.459 577 966.059 586.4 972.459 596.8L1163.86 895H1015.06C1002.26 895 991.259 893 982.059 889C972.859 884.6 965.259 877 959.259 866.2L820.059 638.8C814.459 629.2 808.659 623 802.659 620.2C796.659 617.4 787.659 616 775.659 616H740.859V895H575.259V0.399966H740.859Z" fill="#D3513E"></path>
                    <path d="M1509.34 266.8C1555.74 266.8 1597.94 274.2 1635.94 289C1673.94 303.8 1706.54 325 1733.74 352.6C1760.94 379.8 1781.94 413 1796.74 452.2C1811.54 491.4 1818.94 535.6 1818.94 584.8C1818.94 634 1811.54 678.4 1796.74 718C1781.94 757.2 1760.94 790.6 1733.74 818.2C1706.54 845.8 1673.94 867 1635.94 881.8C1597.94 896.6 1555.74 904 1509.34 904C1462.54 904 1419.94 896.6 1381.54 881.8C1343.54 867 1310.94 845.8 1283.74 818.2C1256.54 790.6 1235.34 757.2 1220.14 718C1205.34 678.4 1197.94 634 1197.94 584.8C1197.94 535.6 1205.34 491.4 1220.14 452.2C1235.34 413 1256.54 379.8 1283.74 352.6C1310.94 325 1343.54 303.8 1381.54 289C1419.94 274.2 1462.54 266.8 1509.34 266.8ZM1509.34 779.8C1556.54 779.8 1591.54 763.6 1614.34 731.2C1637.14 698.4 1648.54 649.8 1648.54 585.4C1648.54 521.4 1637.14 473.2 1614.34 440.8C1591.54 408 1556.54 391.6 1509.34 391.6C1460.94 391.6 1425.34 408 1402.54 440.8C1379.74 473.2 1368.34 521.4 1368.34 585.4C1368.34 649.8 1379.74 698.4 1402.54 731.2C1425.34 763.6 1460.94 779.8 1509.34 779.8Z" fill="#E0B467"></path>
                    <path d="M2201.92 266.8C2248.32 266.8 2290.52 274.2 2328.52 289C2366.52 303.8 2399.12 325 2426.32 352.6C2453.52 379.8 2474.52 413 2489.32 452.2C2504.12 491.4 2511.52 535.6 2511.52 584.8C2511.52 634 2504.12 678.4 2489.32 718C2474.52 757.2 2453.52 790.6 2426.32 818.2C2399.12 845.8 2366.52 867 2328.52 881.8C2290.52 896.6 2248.32 904 2201.92 904C2155.12 904 2112.52 896.6 2074.12 881.8C2036.12 867 2003.52 845.8 1976.32 818.2C1949.12 790.6 1927.92 757.2 1912.72 718C1897.92 678.4 1890.52 634 1890.52 584.8C1890.52 535.6 1897.92 491.4 1912.72 452.2C1927.92 413 1949.12 379.8 1976.32 352.6C2003.52 325 2036.12 303.8 2074.12 289C2112.52 274.2 2155.12 266.8 2201.92 266.8ZM2201.92 779.8C2249.12 779.8 2284.12 763.6 2306.92 731.2C2329.72 698.4 2341.12 649.8 2341.12 585.4C2341.12 521.4 2329.72 473.2 2306.92 440.8C2284.12 408 2249.12 391.6 2201.92 391.6C2153.52 391.6 2117.92 408 2095.12 440.8C2072.32 473.2 2060.92 521.4 2060.92 585.4C2060.92 649.8 2072.32 698.4 2095.12 731.2C2117.92 763.6 2153.52 779.8 2201.92 779.8Z" fill="#6BB7EE"></path>
                    <path d="M2782.29 0.399966V895H2616.69V0.399966H2782.29Z" fill="#C45946"></path>
                </svg>
            `;
        }
    }

    customElements.define('skool-icon', SkoolIcon);
}


if (!customElements.get('skool-icon-mono')) {
    class SkoolIconMono extends HTMLElement {
        constructor() {
            super();
            this.attachShadow({ mode: 'open' });
        }

        connectedCallback() {
            this.render();
        }

        render() {
            this.shadowRoot.innerHTML = `
                <style>
                    :host {
                        display: inline-block;
                        width: 1.5em;
                        height: 1.5em;
                        color: currentColor;
                    }
                    svg {
                        width: 100%;
                        height: 100%;
                        display: block;
                        fill: currentColor;
                    }
                </style>

                <!-- Skool silhouette (one path, inherits color) -->
                <svg viewBox="0 0 2783 905" xmlns="http://www.w3.org/2000/svg">
                    <path d="M429 403.6C424.6 410.4 420 415.4 415.2 418.6C410.8 421.4 404.6 422.8 396.6 422.8C388.6 422.8 380.4 420.8 372 416.8C363.6 412.8 354.2 408.6 343.8 404.2C333.4 399.4 321.4 395 307.8 391C294.6 387 279.2 385 261.6 385C234.8 385 214 390.6 199.2 401.8C184.4 412.6 177 427 177 445C177 457.4 181.2 467.8 189.6 476.2C198 484.6 209 492 222.6 498.4C236.6 504.4 252.4 510.2 270 515.8C287.6 521 305.6 526.8 324 533.2C342.8 539.6 361 547 378.6 555.4C396.2 563.8 411.8 574.4 425.4 587.2C439.4 599.6 450.6 614.8 459 632.8C467.4 650.4 471.6 671.8 471.6 697C471.6 727 466 754.8 454.8 780.4C444 805.6 428 827.4 406.8 845.8C385.6 864.2 359.2 878.6 327.6 889C296 899.4 259.6 904.6 218.4 904.6C197.2 904.6 176.2 902.6 155.4 898.6C134.6 895 114.8 889.8 96 883C77.2 875.8 59.6 867.6 43.2 858.4C26.8 849.2 12.6 839.2 0.6 828.4L39 766.6C43.4 759.4 48.8 753.8 55.2 749.8C62 745.8 70.6 743.8 81 743.8C91 743.8 100.2 746.4 108.6 751.6C117 756.4 126.4 761.8 136.8 767.8C147.2 773.4 159.4 778.8 173.4 784C187.8 788.8 205.6 791.2 226.8 791.2C242.8 791.2 256.6 789.4 268.2 785.8C279.8 782.2 289.2 777.4 296.4 771.4C303.6 765 308.8 758 312 750.4C315.6 742.4 317.4 734.2 317.4 725.8C317.4 712.2 313 701.2 304.2 692.8C295.8 684 284.6 676.4 270.6 670C257 663.6 241.2 657.8 223.2 652.6C205.2 647.4 186.8 641.6 168 635.2C149.6 628.8 131.4 621.2 113.4 612.4C95.8 603.6 80 592.6 66 579.4C52.4 565.8 41.2 549.2 32.4 529.6C24 510 19.8 486.2 19.8 458.2C19.8 432.6 24.8 408.4 34.8 385.6C44.8 362.4 59.8 342 79.8 324.4C99.8 306.8 124.6 292.8 154.2 282.4C184.2 272 218.8 266.8 258 266.8C302 266.8 342 274 378 288.4C414 302.8 443.6 321.6 466.8 344.8L429 403.6ZM740.859 0.399966V895H575.259V0.399966H740.859ZM947.859 304.6C954.659 295.4 962.259 288.4 970.659 283.6C979.459 278.8 990.459 276.4 1003.66 276.4H1154.86L977.259 502C963.259 520.8 947.059 535.6 928.659 546.4C937.859 552.8 945.859 560.2 952.659 568.6C959.459 577 966.059 586.4 972.459 596.8L1163.86 895H1015.06C1002.26 895 991.259 893 982.059 889C972.859 884.6 965.259 877 959.259 866.2L820.059 638.8C814.459 629.2 808.659 623 802.659 620.2C796.659 617.4 787.659 616 775.659 616H740.859V508H768.459C778.859 508 787.059 506.6 793.059 503.8C799.059 500.6 805.059 495 811.059 487L947.859 304.6ZM1509.34 266.8C1555.74 266.8 1597.94 274.2 1635.94 289C1673.94 303.8 1706.54 325 1733.74 352.6C1760.94 379.8 1781.94 413 1796.74 452.2C1811.54 491.4 1818.94 535.6 1818.94 584.8C1818.94 634 1811.54 678.4 1796.74 718C1781.94 757.2 1760.94 790.6 1733.74 818.2C1706.54 845.8 1673.94 867 1635.94 881.8C1597.94 896.6 1555.74 904 1509.34 904C1462.54 904 1419.94 896.6 1381.54 881.8C1343.54 867 1310.94 845.8 1283.74 818.2C1256.54 790.6 1235.34 757.2 1220.14 718C1205.34 678.4 1197.94 634 1197.94 584.8C1197.94 535.6 1205.34 491.4 1220.14 452.2C1235.34 413 1256.54 379.8 1283.74 352.6C1310.94 325 1343.54 303.8 1381.54 289C1419.94 274.2 1462.54 266.8 1509.34 266.8ZM1509.34 779.8C1556.54 779.8 1591.54 763.6 1614.34 731.2C1637.14 698.4 1648.54 649.8 1648.54 585.4C1648.54 521.4 1637.14 473.2 1614.34 440.8C1591.54 408 1556.54 391.6 1509.34 391.6C1460.94 391.6 1425.34 408 1402.54 440.8C1379.74 473.2 1368.34 521.4 1368.34 585.4C1368.34 649.8 1379.74 698.4 1402.54 731.2C1425.34 763.6 1460.94 779.8 1509.34 779.8ZM2201.92 266.8C2248.32 266.8 2290.52 274.2 2328.52 289C2366.52 303.8 2399.12 325 2426.32 352.6C2453.52 379.8 2474.52 413 2489.32 452.2C2504.12 491.4 2511.52 535.6 2511.52 584.8C2511.52 634 2504.12 678.4 2489.32 718C2474.52 757.2 2453.52 790.6 2426.32 818.2C2399.12 845.8 2366.52 867 2328.52 881.8C2290.52 896.6 2248.32 904 2201.92 904C2155.12 904 2112.52 896.6 2074.12 881.8C2036.12 867 2003.52 845.8 1976.32 818.2C1949.12 790.6 1927.92 757.2 1912.72 718C1897.92 678.4 1890.52 634 1890.52 584.8C1890.52 535.6 1897.92 491.4 1912.72 452.2C1927.92 413 1949.12 379.8 1976.32 352.6C2003.52 325 2036.12 303.8 2074.12 289C2112.52 274.2 2155.12 266.8 2201.92 266.8ZM2201.92 779.8C2249.12 779.8 2284.12 763.6 2306.92 731.2C2329.72 698.4 2341.12 649.8 2341.12 585.4C2341.12 521.4 2329.72 473.2 2306.92 440.8C2284.12 408 2249.12 391.6 2201.92 391.6C2153.52 391.6 2117.92 408 2095.12 440.8C2072.32 473.2 2060.92 521.4 2060.92 585.4C2060.92 649.8 2072.32 698.4 2095.12 731.2C2117.92 763.6 2153.52 779.8 2201.92 779.8ZM2782.29 0.399966V895H2616.69V0.399966H2782.29Z" />
                </svg>
            `;
        }
    }

    customElements.define('skool-icon-mono', SkoolIconMono);
}

