<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('lead_capture_form', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('user_id')->nullable();
            $table->unsignedBigInteger('page_id')->nullable();

            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('page_id')->references('id')->on('subcards')->onDelete('cascade');

            $table->string('title');
            $table->string('slug')->unique();
            $table->string('image')->nullable();
            $table->boolean('active_image')->default(true);
            $table->string('video')->nullable();
            $table->boolean('active_video')->default(true);
            $table->text('description')->nullable();
            $table->string('sender_email');
            $table->text('email_received')->nullable();
            $table->string('link_attached')->nullable();
            $table->boolean('is_active')->default(true);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('lead_capture_form');
    }
};
