<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->boolean('is_on_deal')->default(false);
            $table->decimal('deal_price', 10, 2)->nullable(); // FINAL price
            $table->unsignedInteger('discount_percentage')->nullable(); // 0–100

            $table->timestamp('deal_starts_at')->nullable();
            $table->timestamp('deal_ends_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
