<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('products_collection', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('user_id')->nullable();
            $table->unsignedBigInteger('page_id')->nullable();

            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('page_id')->references('id')->on('subcards')->onDelete('cascade');
            $table->string('image')->nullable();
            $table->string('title');
            $table->text('description')->nullable();

            $table->integer('order')->nullable();
            $table->boolean('is_active')->default(true);

            $table->timestamps();
        });

        Schema::table('products', function (Blueprint $table) {
            // Drop existing foreign keys if they exist
            // $table->dropForeign(['collection_id']);
            // $table->dropForeign(['category_id']);

            // Re-add foreign keys with nullOnDelete

            $table->unsignedBigInteger('collection_id')->nullable();

            $table->foreign('collection_id')
                ->references('id')
                ->on('products_collection')
                ->nullOnDelete();

            // $table->foreign('category_id')
            //     ->references('id')
            //     ->on('product_categories')
            //     ->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('products_collection');
    }
};
