<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Step 1: Clean up invalid enum values
        DB::table('buttons')
            ->where('type', 'community')
            ->where('view', 'communities')
            ->update(['type' => 'link', 'view' => 'links']);

        // Step 2: Change enum -> string
        Schema::table('buttons', function (Blueprint $table) {
            $table->string('type', 50)->default('link')->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        /// If you want to reverse, you can re-create the enum
        Schema::table('buttons', function (Blueprint $table) {
            $table->enum('type', [
                'link',
                'email',
                'phone',
                'sms',
                'whatsapp',
                'telegram',
                'zoom',
                'cashapp',
                'paypal_link',
                'paypal_email',
                'apple_pay',
                'venmo',
                'credit',
                'zelle',
                'vcf',
                'help',
                'exchange',
                'bio',
                'shop',
                'services',
                'feedback',
                'events',
                'sales',
                'google_map',
                'apple_map',
                'waze',
                'fb_community',
                'whatsapp_community',
                'discord_community',
                'telegram_community',
                'community' // add back if needed
            ])->default('link')->change();
        });
    }
};
