<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sales_videos', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('sales_id')->nullable();
            $table->foreign('sales_id')->references('id')->on('sales')->onDelete('cascade');

            $table->string('video_link');
            $table->string('custom_thumbnail')->nullable();
            $table->integer('order')->nullable();
            $table->boolean('is_active')->default(true);
            $table->string('shop_online_button')->nullable();
            $table->string('shop_online_link')->nullable();

            $table->timestamps();
        });

        Schema::create('sales_images', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('sales_id')->nullable();
            $table->foreign('sales_id')->references('id')->on('sales')->onDelete('cascade');

            $table->string('image_path');
            $table->integer('order')->nullable();
            $table->boolean('is_active')->default(true);
            $table->string('shop_online_button')->nullable();
            $table->string('shop_online_link')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sales_videos');
    }
};
