<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('events', function (Blueprint $table) {
            // Rename column
            $table->renameColumn('image', 'event_poster');

            // Modify existing column type to JSON
            $table->json('event_video_link')->nullable()->change();

            // Add a new JSON column (only if it doesn't exist yet)
            $table->json('images')->nullable();
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
