<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sponsor_default_socials', function (Blueprint $table) {
            $table->id();
            $table->string('link');
            $table->enum('type', ['facebook', 'x', 'linkedin', 'instagram', 'tiktok', 'youtube', 'clubhouse', 'threads', 'fanbase', 'snapchat', 'pinterest'])->default('facebook');
            $table->unsignedBigInteger('sponsor_id')->nullable();
            $table->foreign('sponsor_id')->references('id')->on('sponsors')->onDelete('set null'); // owner
            $table->integer('order')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
