<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sponsor_default_buttons', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('link');
            $table->enum('type', ['link', 'email', 'phone', 'sms', 'whatsapp', 'telegram', 'zoom', 'cashapp', 'paypal_link', 'paypal_email', 'apple_pay', 'venmo', 'credit', 'zelle'])->default('link');
            $table->enum('view', ['links', 'contacts', 'payments'])->default('links');
            $table->integer('order')->nullable();
            $table->unsignedBigInteger('sponsor_id')->nullable();
            $table->foreign('sponsor_id')->references('id')->on('sponsors')->onDelete('set null');
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sponsor_default_buttons');
    }
};
