<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('network', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->nullable(); //user's id if main card is used
            $table->unsignedBigInteger('page_id')->nullable(); //subcard's id if subcard card is used
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('page_id')->references('id')->on('subcards')->onDelete('cascade');
            $table->unsignedBigInteger('network_id')->nullable(); //id of card holder you are adding
            $table->enum('card_type', ['main', 'sub'])->nullable();
            $table->enum('type', ['saved', 'added', 'submission'])->default('saved');
            $table->string('note')->nullable();
            $table->timestamps();
        });

        Schema::create('lets_connect', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->unsignedBigInteger('page_id')->nullable();

            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('page_id')->references('id')->on('subcards')->onDelete('cascade');

            $table->string('email');
            $table->string('firstname');
            $table->string('lastname');
            $table->string('phone');
            $table->enum('gender', ['Male', 'Female']);
            $table->string('profile_pic')->nullable();
            $table->string('job_title')->nullable();
            $table->string('company')->nullable();
            $table->string('company_website')->nullable();
            $table->text('we_met_at')->nullable();
            $table->string('country')->nullable();
            $table->enum('type', ['added', 'submission'])->default('submission');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('network');
    }
};
