<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->enum('user_type', ['Free', 'Basic', 'Gold', 'Platinum', 'Sponsored'])
                ->default('Free')
                ->change();
        });

        Schema::table('ads', function (Blueprint $table) {
            $table->enum('display_in', ['Free', 'Sponsored'])->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
