<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('analytics', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('user_id')->nullable();
            $table->unsignedBigInteger('button_id')->nullable();
            $table->unsignedBigInteger('social_id')->nullable();
            $table->unsignedBigInteger('ad_id')->nullable();

            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('button_id')->references('id')->on('buttons')->onDelete('cascade');
            $table->foreign('social_id')->references('id')->on('socials')->onDelete('cascade');
            $table->foreign('ad_id')->references('id')->on('ads')->onDelete('cascade');

            $table->string('ip_address')->nullable();
            $table->string('city')->nullable();
            $table->string('region')->nullable();
            $table->string('country')->nullable();
            $table->string('referrer')->nullable();
            $table->string('device_type')->nullable();

            $table->unsignedBigInteger('page_id')->nullable();
            $table->foreign('page_id')->references('id')->on('subcards')->onDelete('cascade');

            $table->enum('type', ['button_click', 'qr_scan', 'social_click', 'card_view', 'ad_click'])->default('button_click');

            $table->timestamp('viewed_at')->nullable();
            $table->timestamp('clicked_at')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('table_analytics');
    }
};
