<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subcards', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            // Then define the foreign key
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->string('firstname')->nullable();
            $table->string('lastname')->nullable();
            $table->string('username')->unique();
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->string('profile_pic')->nullable();
            $table->string('cover_pic')->nullable();
            $table->string('company_logo')->nullable();
            $table->string('job_title')->nullable();
            $table->text('bio')->nullable();
            $table->text('bio_long')->nullable();
            $table->string('company')->nullable();
            $table->string('company_website')->nullable();
            $table->boolean('is_active')->default(true);
            $table->boolean('active_card')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subcards');
    }
};
