<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('videos', function (Blueprint $table) {
            $table->id();
            // $table->foreignId('user_id')->constraint('user_id')->onDelete('cascade'); // owner
            $table->unsignedBigInteger('user_id')->nullable();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->string('title');
            $table->string('link');
            $table->enum('video_type', ['youtube', 'vimeo'])->default('youtube');
            $table->string('thumbnail')->nullable();
            $table->integer('order')->nullable();
            $table->boolean('is_active')->default(true);
            // $table->unsignedBigInteger('page_id')->nullable();
            // $table->foreign('page_id')->references('id')->on('subcards')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('videos');
    }
};
