<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('buttons', function (Blueprint $table) {
            $table->id(); // button id
            $table->string('title');
            $table->string('link');
            $table->enum('type', ['link', 'email', 'phone', 'sms', 'whatsapp', 'telegram', 'zoom', 'cashapp', 'paypal_link', 'paypal_email', 'apple_pay', 'venmo', 'credit', 'zelle'])->default('link');
            $table->enum('view', ['links', 'contacts', 'payments'])->default('links');
            $table->integer('order')->nullable();
            // 👇 add this before the foreign key
            $table->unsignedBigInteger('user_id')->nullable();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade'); // owner
            $table->boolean('is_active')->default(true);
            // $table->unsignedBigInteger('page_id')->nullable();
            // $table->foreign('page_id')->references('id')->on('subcards')->onDelete('cascade');
            // $table->foreignId('page_id')->nullable()->constrained('subcards')->cascadeOnDelete();

            $table->boolean('is_sponsored')->default(true);
            // $table->unsignedBigInteger('sponsor_id')->nullable();
            // $table->foreign('sponsor_id')->references('id')->on('sponsors')->onDelete('set null');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('buttons');
    }
};
