<?php

namespace App\Services;

use Twilio\Rest\Client;

class TwilioService
{
    protected Client $client;

    public function __construct()
    {
        $this->client = new Client(env('TWILIO_SID'), env('TWILIO_AUTH_TOKEN'));
    }

    public function sendSms(string $to, string $message)
    {
        return $this->client->messages->create(
            $to,
            [
                'from' => env('TWILIO_SMS_FROM'),
                'body' => $message,
            ]
        );
    }

    public function sendWhatsapp(string $to, string $message)
    {
        return $this->client->messages->create(
            'whatsapp:' . $to,
            [
                'from' => env('TWILIO_WHATSAPP_FROM'),
                'body' => $message,
            ]
        );
    }
}
