<?php

namespace App\Policies;

use App\Models\User;
use App\Models\TrustedNetwork;

class TrustedNetworkPolicy
{
    public function viewAny(User $user): bool
    {
        if ($user->is_admin) {
            return true;
        }

        // Return false for all other users
        return false;
    }

    public function view(User $user): bool
    {
        // Check if the user is pro or platinum card holder before accessing the products tab
        // return in_array($user->user_type, ['Gold', 'Platinum']) || $user->is_admin == true;
        return $user->user_type == 'Platinum' || $user->is_admin == true;
    }

    public function create(User $user): bool
    {
        // return in_array($user->user_type, ['Gold', 'Platinum']) || $user->is_admin == true;
        return $user->user_type == 'Platinum' || $user->is_admin == true;
    }

    public function update(User $user): bool
    {
        // return in_array($user->user_type, ['Gold', 'Platinum']) || $user->is_admin == true;
        return $user->user_type == 'Platinum' || $user->is_admin == true;
    }

    public function delete(User $user): bool
    {
        // return in_array($user->user_type, ['Gold', 'Platinum']) || $user->is_admin == true;
        return $user->user_type == 'Platinum' || $user->is_admin == true;
    }

    public function restore(User $user, TrustedNetwork $network): bool
    {
        // return in_array($user->user_type, ['Gold', 'Platinum']) || $user->is_admin == true;
        return $user->user_type == 'Platinum' || $user->is_admin == true;
    }

    public function forceDelete(User $user, TrustedNetwork $network): bool
    {
        // return in_array($user->user_type, ['Gold', 'Platinum']) || $user->is_admin == true;
        return $user->user_type == 'Platinum' || $user->is_admin == true;
    }
}
