<?php

namespace App\Policies;

use App\Models\Social;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class SocialPolicy
{
    /**
     * Determine whether the user can view any models.
     */

    public $socials;

    public function viewAny(User $user): bool
    {
        if ($user->is_admin) {
            return true;
        }

        // Return false for all other users
        return false;
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, Social $social): bool
    {
        return false;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        // $checkifactive = User::where('id', auth()->user()->id)
        //     ->where('active_card', true)->count();
        // if ($checkifactive > 0) {

        //     $this->user = User::where('id', auth()->user()->id)->first(['username', 'firstname', 'lastname', 'job_title', 'company', 'company_website', 'bio', 'profile_pic', 'user_type']);

        // } else {

        //     $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
        //         ->where('subcards.user_id', auth()->user()->id)
        //         ->where('subcards.active_card', true)
        //         ->first([
        //             'subcards.username',
        //             'subcards.job_title',
        //             'subcards.company',
        //             'subcards.company_website',
        //             'subcards.bio',
        //             'subcards.profile_pic',
        //             'subcards.firstname',
        //             'subcards.lastname',
        //             'users.user_type',
        //         ]);

        //         $this->page_id = SubCard::where('user_id', auth()->user()->id)
        //         ->where('active_card', true)
        //         ->pluck('id')
        //         ->first();
        // }

        $this->socials = Social::where('user_id', auth()->user()->id)->get();
        // dd($user->user_type, $this->socials->count(), $user->user_type == 'Free' && $this->socials->count() < 3);
        return ($user->user_type == 'Free' && $this->socials->count() < 3) || (in_array($user->user_type, ['Basic', 'Gold', 'Platinum', 'Sponsored', 'Influencer'])) || ($user->is_admin == true);
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, Social $social): bool
    {
        // return false;
        $this->socials = Social::where('user_id', auth()->user()->id)->get();

        return ($user->user_type == 'Free' && $this->socials->count() < 3) || in_array($user->user_type, ['Basic', 'Gold', 'Platinum', 'Sponsored', 'Influencer']) || $user->is_admin == true;
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, Social $social): bool
    {
        // return false;
        $this->socials = Social::where('user_id', auth()->user()->id)->get();

        return ($user->user_type == 'Free' && $this->socials->count() < 3) || in_array($user->user_type, ['Basic', 'Gold', 'Platinum', 'Sponsored', 'Influencer']) || $user->is_admin == true;
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, Social $social): bool
    {
        // return false;
        $this->socials = Social::where('user_id', auth()->user()->id)->get();

        return ($user->user_type == 'Free' && $this->socials->count() < 3) || in_array($user->user_type, ['Basic', 'Gold', 'Platinum', 'Sponsored', 'Influencer']) || $user->is_admin == true;
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, Social $social): bool
    {
        // return false;
        $this->socials = Social::where('user_id', auth()->user()->id)->get();

        return ($user->user_type == 'Free' && $this->socials->count() < 3) || in_array($user->user_type, ['Basic', 'Gold', 'Platinum', 'Sponsored', 'Influencer']) || $user->is_admin == true;
    }
}
