<?php

namespace App\Policies;

use App\Models\Service;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class ServicePolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        if ($user->is_admin) {
            return true;
        }

        // Return false for all other users
        return false;
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user): bool
    {
        // Check if the user is pro or platinum card holder before accessing the services tab
        return in_array($user->user_type, ['Gold', 'Platinum']) || $user->is_admin == true;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return in_array($user->user_type, ['Gold', 'Platinum']) || $user->is_admin == true;
    }

    /**
     * Determine whether the user can update the model.
     */

    public function update(User $user): bool
    {
        return in_array($user->user_type, ['Gold', 'Platinum']) || $user->is_admin == true;
    }

    /**
     * Determine whether the user can delete the model.
     */
    // public function delete(User $user, Product $product): bool
    public function delete(User $user): bool
    {
        return in_array($user->user_type, ['Gold', 'Platinum']) || $user->is_admin == true;
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, Service $service): bool
    {
        return in_array($user->user_type, ['Gold', 'Platinum']) || $user->is_admin == true;
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, Service $service): bool
    {
        return in_array($user->user_type, ['Gold', 'Platinum']) || $user->is_admin == true;
    }
}
