<?php

namespace App\Policies;

use App\Models\User;
use App\Models\SaleVideo;

class SalesVideoPolicy
{
    public $video;

    public function viewAny(User $user): bool
    {
        if ($user->is_admin) {
            return true;
        }

        // Return false for all other users
        return false;
    }

    public function view(User $user): bool
    {
        // return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
        // return (in_array($user->user_type, ['Platinum', 'Gold']) && $user->active_card) || $user->is_admin == true;
        return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
    }

    // public function create(User $user): bool
    // {
    //     // $this->video = SaleVideo::where('user_id', $user->id)->where('page_id', NULL)->get();

    //     $this->video = auth()->user()->sales()->sale_videos();
    //     return in_array($user->user_type, ['Platinum', 'Gold']) ||
    //         $user->is_admin && $this->video->count() < 10;
    // }

    public function create(User $user): bool
    {
        $videos = $user->sales()->with('sale_videos')->get()
            ->pluck('sale_videos')
            ->flatten();

        $videosCount = $videos->count();

        // return ((in_array($user->user_type, ['Platinum', 'Gold'])  && $user->active_card)
        //     || $user->is_admin) && $videosCount < 10;

        return (in_array($user->user_type, ['Platinum', 'Gold'])
            || $user->is_admin) && $videosCount < 10;
    }

    public function update(User $user): bool
    {
        // return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
        // return (in_array($user->user_type, ['Platinum', 'Gold']) && $user->active_card) || $user->is_admin == true;

        return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
    }

    public function delete(User $user): bool
    {
        // return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
        // return (in_array($user->user_type, ['Platinum', 'Gold']) && $user->active_card) || $user->is_admin == true;

        return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
    }

    public function restore(User $user): bool
    {
        // return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
        // return (in_array($user->user_type, ['Platinum', 'Gold']) && $user->active_card) || $user->is_admin == true;

        return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
    }

    public function forceDelete(User $user): bool
    {
        // return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
        // return (in_array($user->user_type, ['Platinum', 'Gold']) && $user->active_card) || $user->is_admin == true;

        return in_array($user->user_type, ['Platinum', 'Gold']) || $user->is_admin == true;
    }
}
