<?php

namespace App\Policies;

use App\Models\Image;
use App\Models\User;
use App\Models\SubCard;
use Illuminate\Auth\Access\Response;

class ImagePolicy
{
    public function viewAny(User $user): bool
    {
        if ($user->is_admin) {
            return true;
        }

        // Return false for all other users
        return false;
    }

    public function view(User $user): bool
    {
        return in_array($user->user_type, ['Sponsored', 'Gold', 'Platinum']) || $user->is_admin == true;
    }

    public function create(User $user): bool
    {
        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($checkifactive < 1) {
            $page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $images_count = Image::where('page_id', $page_id)->count();
        } else {
            $images_count = Image::where('user_id', auth()->user()->id)->whereNull('page_id')->count();
        }

        return in_array($user->user_type, ['Sponsored', 'Gold', 'Platinum']) && $images_count < 10 || $user->is_admin == true;
    }

    public function update(User $user): bool
    {
        return in_array($user->user_type, ['Sponsored', 'Gold', 'Platinum']) || $user->is_admin == true;
    }

    public function delete(User $user): bool
    {
        return in_array($user->user_type, ['Sponsored', 'Gold', 'Platinum']) || $user->is_admin == true;
    }

    public function restore(User $user, Image $image): bool
    {
        return in_array($user->user_type, ['Sponsored', 'Gold', 'Platinum']) || $user->is_admin == true;
    }

    public function forceDelete(User $user, Image $image): bool
    {
        return in_array($user->user_type, ['Sponsored', 'Gold', 'Platinum']) || $user->is_admin == true;
    }
}
