<?php

namespace App\Policies;

use App\Models\User;

class AnalyticsPolicy
{
    public function viewAny(User $user): bool
    {
        if ($user->is_admin) {
            return true;
        }

        // Return false for all other users
        return false;
    }

    public function view(User $user): bool
    {
        // Check if the user is pro or platinum card holder before accessing the products tab
        return in_array($user->user_type, ['Basic', 'Gold', 'Platinum', 'Sponsored', 'Influencer']) || $user->is_admin == true;
    }
}
