<?php

namespace App\Policies;

use App\Models\SubCard;
use App\Models\User;

class AddNewPagesPolicy
{
    public function viewAny(User $user): bool
    {
        if ($user->is_admin) {
            return true;
        }

        // Return false for all other users
        return false;
    }

    public function view(User $user): bool
    {
        return in_array($user->user_type, ['Influencer', 'Sponsored', 'Gold', 'Platinum']) || $user->is_admin;
    }

    public function create(User $user): bool
    {
        $subcardsCount = $user->subcards()->count();

        $maxCard = 0;

        match ($user->user_type) {
            'Gold' => $maxCard = 3,
            'Platinum' => $maxCard = 12,
            'Sponsored', 'Influencer' => $maxCard = 1,
            default => null,
        };

        $availableSlot = $maxCard - $subcardsCount;

        return (
            in_array($user->user_type, ['Influencer', 'Sponsored', 'Gold', 'Platinum'])
            && $availableSlot > 0
        ) || $user->is_admin;
    }

    public function update(User $user): bool
    {
        return in_array($user->user_type, ['Influencer', 'Sponsored', 'Gold', 'Platinum']) || $user->is_admin;
    }

    public function delete(User $user): bool
    {
        return in_array($user->user_type, ['Influencer', 'Sponsored', 'Gold', 'Platinum']) || $user->is_admin;
    }
}
