<?php

namespace App\Policies;

use App\Models\User;

class AdPolicy
{
    public function viewAny(User $user): bool
    {
        if ($user->is_admin) {
            return true;
        }

        // Return false for all other users
        return false;
    }

    public function view(User $user): bool
    {
        return (in_array($user->user_type, ['Basic', 'Gold', 'Platinum']) || $user->is_admin);
    }

    public function create(User $user): bool
    {
        return (in_array($user->user_type, ['Basic', 'Gold', 'Platinum']) || $user->is_admin);
    }

    public function update(User $user): bool
    {
        return (in_array($user->user_type, ['Basic', 'Gold', 'Platinum']) || $user->is_admin);
    }

    public function delete(User $user): bool
    {
        return (in_array($user->user_type, ['Basic', 'Gold', 'Platinum']) || $user->is_admin);
    }
}
