<?php

namespace App\Observers;

use App\Models\FeedbackForm;
use App\Models\User;
use App\Models\SubCard;
use App\Notifications\UserNotification;
use App\Helpers\FirebaseHelper;

class FeedbackFormObserver
{
    public function created(FeedbackForm $form): void
    {
        if (!empty($form->page_id)) {
            // Subcard
            $owner = SubCard::find($form->page_id);
            if (! $owner) {
                \Log::warning("SubCard not found: {$form->page_id}");
                return;
            }

            // Notify the subcard itself
            $owner->notify(
                new UserNotification(
                    title: "Form Submission: Feedback Form",
                    message: "<span class='font-semibold'>{$form->firstname} {$form->lastname}</span> submitted a feedback form. Please check the submission.",
                    url: route('dashboard.network'),
                )
            );
        } elseif (!empty($form->user_id)) {
            // Main card user
            $owner = User::find($form->user_id);
            if (! $owner) return;

            if ($owner->is_admin) {
                return;
            }

            $owner->notify(
                new UserNotification(
                    title: "Form Submission: Feedback Form",
                    message: "<span class='font-semibold'>{$form->firstname} {$form->lastname}</span> submitted a feedback form. Please check the submission.",
                    url: route('dashboard.network')
                )
            );

            \Log::info("Notification sent to User ID: {$owner->id}");
        }
    }
}
