<?php

namespace App\Notifications;

use Illuminate\Auth\Notifications\VerifyEmail as VerifyEmailBase;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Support\Facades\URL;
use Carbon\Carbon;
use App\Settings\CardDefaultsSetting;

class CustomVerifyEmail extends VerifyEmailBase implements ShouldQueue
{
    use Queueable;

    public $site_name;

    protected function verificationUrl($notifiable)
    {
        return URL::temporarySignedRoute(
            'verification.verify',
            Carbon::now()->addMinutes(60),
            [
                'id' => $notifiable->getKey(),
                'hash' => sha1($notifiable->getEmailForVerification()),
            ]
        );
    }

    public function toMail($notifiable)
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;

        $verifyUrl = $this->verificationUrl($notifiable);

        return (new MailMessage)
            ->subject("{$this->site_name} – Confirm your email address")
            ->greeting("Hi {$notifiable->firstname} {$notifiable->lastname} ({$notifiable->email}) 👋")
            ->line("Thanks for signing up with {$this->site_name}!")
            ->line('To complete your registration and activate your account, please confirm your email address by clicking the button below.')
            ->action('Verify Email', $verifyUrl)
            ->line("If you didn’t create an account, you can safely ignore this email — no action is needed.")
            ->salutation("Thanks again,\n\nThe {$this->site_name} Team");
    }
}
