<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;
use App\Observers\UpgradeRequestObserver;

#[ObservedBy([UpgradeRequestObserver::class])]

class UpgradeRequest extends Model
{
    protected $table = 'upgrade_request';
    protected $fillable = [
        'user_id',
        'page_id',
        'old_plan',
        'plan',
        'receipt',
        'is_upgraded'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    protected static function booted()
    {
        static::deleting(function ($request) {
            if ($request->receipt) {
                $path = 'app/public/' . $request->receipt;
                unlink(storage_path($path));
            }
        });
    }
}
