<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;
use App\Observers\TrustedNetworkObserver;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;

#[ObservedBy([TrustedNetworkObserver::class])]

class TrustedNetwork extends Model implements Sortable
{
    use SortableTrait;

    protected $table = 'trusted_network';
    protected $fillable = [
        'user_id',
        'page_id',
        'member_id',
        'type',
        'team_id',
        'card_type',
        'order',
        'is_accepted'
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'member_id'); // use member_id, not id
    }

    public function subcard()
    {
        return $this->belongsTo(SubCard::class, 'member_id'); // use member_id, not id
    }
}
