<?php


namespace App\Models\Traits;

use App\Models\User;
use App\Models\SubCard;
use Illuminate\Support\Facades\Storage;

trait HasProfilePhoto
{
    public $checkMain;
    public $checkSub;
    public bool $mainCard = false;
    public $page_id;

    public function profilePhotoUrl()
    {
        $user = auth()->user();

        // Check if user has an active SubCard
        $activeSubCard = SubCard::where('user_id', $user->id)
            ->where('active_card', true)
            ->first();

        if ($activeSubCard) {
            // Use SubCard profile photo if available
            return $activeSubCard->profile_pic
                ? asset($activeSubCard->profile_pic)
                : $this->defaultProfilePhotoUrl();
        }

        // Else fallback to User profile photo if active card is true
        if ($user->active_card) {
            return $user->profile_pic
                ? asset($user->profile_pic)
                : $this->defaultProfilePhotoUrl();
        }

        // Default fallback
        return $this->defaultProfilePhotoUrl();
    }

    public function customThumbnailUrl()
    {
        $user = auth()->user();

        // Check if user has an active SubCard
        $activeSubCard = SubCard::where('user_id', $user->id)
            ->where('active_card', true)
            ->first();

        if ($activeSubCard) {
            // Use SubCard thumbnail photo if available
            return $activeSubCard->thumbnail
                ? asset($activeSubCard->thumbnail)
                : $this->profilePhotoUrl();
        }

        // Else fallback to User thumbnail if active card is true
        if ($user->active_card) {
            return $user->thumbnail
                ? asset($user->thumbnail)
                : $this->profilePhotoUrl();
        }

        // Default fallback
        return $this->profilePhotoUrl();
    }

    public function coverPhotoUrl()
    {
        $user = auth()->user();

        $activeSubCard = SubCard::where('user_id', $user->id)
            ->where('active_card', true)
            ->first();

        if ($activeSubCard) {
            return $activeSubCard->cover_pic
                ? asset($activeSubCard->cover_pic)
                // ? Storage::url($activeSubCard->cover_pic)
                : $this->defaultCoverPhotoUrl();
        }

        // Else fallback to User cover_pic if active card is true
        if ($user->active_card) {
            return $user->cover_pic
                ? asset($user->cover_pic)
                // ? Storage::url($user->cover_pic)
                : $this->defaultCoverPhotoUrl();
        }

        // Default fallback
        return $this->defaultCoverPhotoUrl();
    }

    public function defaultProfilePhotoUrl()
    {
        return asset('/img/profile-placeholder.jpg');
    }

    public function defaultCoverPhotoUrl()
    {
        return asset('/img/cover-placeholder.jpg');
    }
}
