<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Product;

class SubscriptionRewards extends Model
{
    protected $fillable = [
        'user_id',
        'page_id',
        'product_id',
        'coin',
        'price',
        'receipt',
        'firstname',
        'lastname',
        'phone',
        'email',
        'special_note',
        'shipping_address',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }

    protected static function booted()
    {
        // if deleting, delete receipt from the server
        static::deleting(function ($subscription) {
            if ($subscription->receipt) {
                $path = 'app/public/' . $subscription->receipt;
                unlink(storage_path($path));
            }
        });
    }
}
