<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Traits\HasServicePhoto;
use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;
use App\Models\User;
use App\Models\Subcard;

class Service extends Model implements Sortable
{

    use SortableTrait;
    use HasServicePhoto;

    protected $fillable = [
        'user_id',
        'page_id',
        'title',
        'description',
        'price',
        'payment_link',
        'service_image',
        'is_active'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function subcard()
    {
        return $this->belongsTo(SubCard::class);
    }

    protected static function booted()
    {
        static::saving(function ($service) {
            // Check if there is an old service image and the service exists
            if ($service->exists && $service->getOriginal('service_image') && $service->service_image !== $service->getOriginal('service_image')) {
                // Get the old service image path
                $oldImagePath = 'app/public/' . $service->getOriginal('service_image');
                unlink(storage_path($oldImagePath));
            }
        });

        // if service is being deleted, check if service exist and service has image. if yes, delete service image
        static::deleting(function ($service) {
            $path = 'app/public/' . $service->service_image;
            if ($service->service_image) {
                @unlink(storage_path($path));
            }
        });
    }
}
