<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Sale;
use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;

class SaleVideo extends Model implements Sortable
{
    use SortableTrait;

    protected $table = 'sales_videos';

    protected $fillable = [
        'sales_id',
        'product_name',
        'description',
        'stock',
        'price',
        'video_link',
        'custom_thumbnail',
        'order',
        'is_active',
        'shop_online_button',
        'shop_online_link'
    ];

    public function sale()
    {
        return $this->belongsTo(Sale::class, 'sales_id');
    }
}
