<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;
use App\Models\User;
use App\Models\SubCard;
use App\Helpers\SavingLinkHelpers;

class Replay extends Model implements Sortable
{
    use SortableTrait;

    protected $fillable = [
        'user_id',
        'page_id',
        'title',
        'link',
        'order',
        'is_active',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function subcard()
    {
        return $this->belongsTo(SubCard::class, 'page_id');
    }

    protected static function booted()
    {
        static::saving(function ($button) {

            static::handleLinkFormatting($button);
        });
    }

    protected static function handleLinkFormatting($button)
    {
        try {
            $securedLink = SavingLinkHelpers::saveSecureLink($button['link']);
            $button['link'] = $securedLink;
        } catch (\InvalidArgumentException $e) {
            throw new \InvalidArgumentException('Invalid input. Please enter a valid URL/link.');
        }
    }
}
