<?php

namespace App\Models;

use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;
use Illuminate\Database\Eloquent\Model;

class ProductMedia extends Model implements Sortable
{
    use SortableTrait;
    protected $table = 'products_media';

    protected $fillable = [
        'product_id',
        'type',
        'path',
        'order',
        'is_active',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }

    // protected static function booted()
    // {
    //     static::saving(function ($product_media) {
    //         // Check if there is an old product image and the product exists
    //         if ($product_media->exists && $product_media->getOriginal('path') && $product_media->type == 'image' && $product_media->path !== $product_media->getOriginal('path')) {
    //             // Get the old product image path
    //             $oldImagePath = 'app/public/' . $product_media->getOriginal('path');
    //             unlink(storage_path($oldImagePath));
    //         }
    //     });

    //     // if product is being deleted, check if product exist and product has image. if yes, delete product image
    //     static::deleting(function ($product_media) {

    //         $mediaItems = $product_media->get();

    //         foreach ($mediaItems as $media) {
    //             if ($media->path && $media->type == 'image') {
    //                 $path = 'app/public/' . $media->path;
    //                 if (file_exists(storage_path($path))) {
    //                     unlink(storage_path($path));
    //                 }
    //             }

    //             $media->delete();
    //         }
    //     });
    // }

    protected static function booted()
    {
        static::saving(function ($product_media) {
            // Delete old image if changed
            if (
                $product_media->exists &&
                $product_media->getOriginal('path') &&
                $product_media->type === 'image' &&
                $product_media->path !== $product_media->getOriginal('path')
            ) {
                $oldImagePath = storage_path('app/public/' . $product_media->getOriginal('path'));
                if (file_exists($oldImagePath)) {
                    unlink($oldImagePath);
                }
            }
        });

        static::deleting(function ($product_media) {
            if ($product_media->path && $product_media->type === 'image') {
                $path = storage_path('app/public/' . $product_media->path);
                if (file_exists($path)) {
                    unlink($path);
                }
            }
        });
    }
}
