<?php

namespace App\Models;

use App\Models\User;
use App\Models\SubCard;
use App\Models\Product;
use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;

use Illuminate\Database\Eloquent\Model;

class ProductCollection extends Model implements Sortable
{
    use SortableTrait;

    protected $table = 'products_collection';

    protected $fillable = [
        'user_id',
        'page_id',
        'image',
        'title',
        'description',
        'order',
        'is_active',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function subcard()
    {
        return $this->belongsTo(SubCard::class, 'page_id');
    }

    public function product()
    {
        return $this->hasMany(Product::class, 'product_id');
    }

    protected static function booted()
    {
        // static::saving(function ($collection) {
        //     // Check if there is an old collection image and the collection exists
        //     if ($collection->exists && $collection->getOriginal('image') && $collection->image !== $collection->getOriginal('image')) {
        //         // Get the old collection image path
        //         $oldImagePath = 'app/public/' . $collection->getOriginal('image');
        //         if (file_exists($oldImagePath)) {
        //             unlink($oldImagePath);
        //         }
        //     }
        // });

        static::updating(function ($collection) {
            if ($collection->isDirty('image') && $collection->getOriginal('image')) {
                $path = 'app/public/' . $collection->getOriginal('image');
                @unlink(storage_path($path));
            }
        });

        // if collection is being deleted, check if product exist and product has image. if yes, delete product image
        static::deleting(function ($collection) {
            //then delete the featured image
            if ($collection->exists && $collection->image) {
                $path = 'app/public/' . $collection->image;
                unlink(storage_path($path));
            }
        });
    }
}
