<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\User;
use App\Models\SubCard;
use App\Models\Product;
use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;

class ProductCategory extends Model implements Sortable
{
    use SortableTrait;

    protected $fillable = [
        'user_id',
        'page_id',
        'title',
        'description',
        'order',
        'is_active',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function subcard()
    {
        return $this->belongsTo(SubCard::class, 'page_id');
    }

    public function product()
    {
        return $this->hasMany(Product::class, 'product_id');
    }
}
