<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;
use App\Observers\PartnershipObserver;

#[ObservedBy([PartnershipObserver::class])]

class Partnership extends Model
{
    protected $fillable = [
        'user_id',
        'page_id',
        'old_partnership',
        'requested_partnership',
        'receipt',
        'is_upgraded'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    protected static function booted()
    {
        static::deleting(function ($request) {
            if ($request->receipt) {
                $path = 'app/public/' . $request->receipt;
                unlink(storage_path($path));
            }
        });
    }
}
