<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\PresentationPage;
use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;

class PageContent extends Model implements Sortable
{
    use SortableTrait;

    protected $table = 'page_content';
    protected $fillable = [
        'page_id',
        'type',
        'title',
        'value',
        'order',
        'is_active',
    ];

    public function page()
    {
        return $this->belongsTo(PresentationPage::class, 'page_id');
    }

    protected static function booted()
    {
        static::updating(function ($content) {
            if ($content->type === 'image' && $content->isDirty('value') && $content->getOriginal('value')) {
                $path = 'app/public/' . $content->getOriginal('value');
                @unlink(storage_path($path));
            }
        });

        static::deleting(function ($content) {
            //then delete the featured image
            if ($content->type === 'image' && $content->exists && $content->value) {
                $path = 'app/public/' . $content->value;
                unlink(storage_path($path));
            }
        });
    }
}
