<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Helpers\SavingLinkHelpers;

use App\Observers\LetsConnectObserver;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;

#[ObservedBy([LetsConnectObserver::class])]

class LetsConnect extends Model
{
    protected $table = 'lets_connect';
    protected $fillable = [
        'user_id',
        'page_id',
        'firstname',
        'lastname',
        'phone',
        'gender',
        'profile_pic',
        'job_title',
        'we_met_at',
        'help',
        'company',
        'company_website',
        'country',
        'email',
        'type',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function subcard()
    {
        return $this->belongsTo(SubCard::class, 'page_id');
    }

    protected static function booted()
    {
        static::saving(function ($user) {
            if ($user->company_website) {
                try {
                    $securedLink = SavingLinkHelpers::saveSecureLink($user['company_website']);
                    $user['company_website'] = $securedLink;
                } catch (\InvalidArgumentException $e) {
                    throw new \InvalidArgumentException('Invalid input. Please enter a valid URL/link.');
                }
            }

            if ($user->phone) {
                try {
                    $contactNumber = SavingLinkHelpers::saveContactNumber($user['phone']);
                    $user['phone'] = $contactNumber;
                } catch (\InvalidArgumentException $e) {
                    throw new \InvalidArgumentException('Invalid input. Please enter a valid number.');
                }
            }
        });

        static::deleting(function ($user) {
            if ($user->profile_pic) {
                $path = 'app/public/' . $user->profile_pic;
                unlink(storage_path($path));
            }
        });
    }
}
