<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;
use App\Models\User;
use App\Models\SubCard;
use Illuminate\Support\Facades\Storage;

class Image extends Model implements Sortable
{
    use SortableTrait;

    protected $fillable = [
        'user_id',
        'page_id',
        'image_path',
        'type',
        'order',
        'is_active',
        'link',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function subcards()
    {
        return $this->belongsTo(SubCard::class);
    }

    protected static function booted()
    {
        static::saving(function ($image) {

            if ($image->exists && $image->getOriginal('image_path') && $image->image_path !== $image->getOriginal('image_path')) {
                Storage::disk('public')->delete($image->getOriginal('image_path'));
            }
        });

        static::deleting(function ($image) {
            if ($image->image_path) {
                Storage::disk('public')->delete($image->image_path);
            }
        });
    }
}
