<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Helpers\SavingLinkHelpers;

use App\Observers\FormSubmissionObserver;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;

#[ObservedBy([FormSubmissionObserver::class])]

class FormSubmission extends Model
{
    protected $fillable = [
        // 'user_id',
        // 'page_id',
        'firstname',
        'lastname',
        'email',
        'phone',
        'referrer',
        'form_id'
    ];

    public function form()
    {
        return $this->belongsTo(LeadCaptureForm::class, 'form_id');
    }

    protected static function booted()
    {
        static::saving(function ($user) {
            if ($user->phone) {
                try {
                    $contactNumber = SavingLinkHelpers::saveContactNumber($user['phone']);
                    $user['phone'] = $contactNumber;
                } catch (\InvalidArgumentException $e) {
                    throw new \InvalidArgumentException('Invalid input. Please enter a valid number.');
                }
            }
        });

        // static::deleting(function ($user) {
        //     if ($user->profile_pic) {
        //         $path = 'app/public/' . $user->profile_pic;
        //         if (file_exists(storage_path($path))) {
        //             unlink(storage_path($path));
        //         }
        //     }
        // });
    }
}
