<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;
use App\Models\User;
use App\Models\Sponsor;

class Ad extends Model
{
    use SortableTrait;

    protected $table = 'ads';

    protected $fillable = [
        'image',
        'link',
        'caption',
        'position',
        'display_in',
        'user_id',
        'order',
        'page_id',
        'is_active',
        'is_admin'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function sponsor()
    {
        return $this->belongsTo(Sponsor::class);
    }

    protected static function booted()
    {
        // static::creating(function ($ad) {
        //     if (auth()->user()->is_admin) {
        //         $ad->is_admin = true;
        //     } else {
        //         $ad->is_admin = false;
        //     }
        // });

        static::saving(function ($ad) {
            // Check if there is an old product image and the product exists
            if ($ad->exists && $ad->getOriginal('image') && $ad->image !== $ad->getOriginal('image')) {
                // Get the old product image path
                $oldImagePath = 'app/public/' . $ad->getOriginal('image');

                unlink(storage_path($oldImagePath));
            }
        });

        // if product is being deleted, check if product exist and product has image. if yes, delete product image
        static::deleting(function ($ad) {
            if ($ad->exists && $ad->image) {
                $path = 'app/public/' . $ad->image;
                unlink(storage_path($path));
            }
        });
    }
}
