<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class OrderMail extends Mailable
{
    use Queueable, SerializesModels;

    public $htmlContent;
    public $subjectLine;
    public $replyToEmail;

    public function __construct($htmlContent, $subjectLine, $replyToEmail)
    {
        $this->htmlContent = $htmlContent;
        $this->subjectLine = $subjectLine;
        $this->replyToEmail = $replyToEmail;
    }

    public function build()
    {
        $mail = $this->html($this->htmlContent)
            ->subject($this->subjectLine);

        if ($this->replyToEmail) {
            $mail->replyTo($this->replyToEmail);
        }

        return $mail;
    }
}
